/*
 * Decompiled with CFR 0.152.
 */
package j;

import j.Blog;
import j.Page;
import j.Settings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import javax.servlet.ServletContext;

public class Article {
    public File file;
    public StringBuffer body = new StringBuffer();
    public String date;
    public String categories;
    public String title;
    public String imageURL;
    public String imageWidth;
    public String imageHeight;
    public String link;

    public Article(String date, String categories, String title, String imageURL, String link, String body) {
        this.date = date;
        this.categories = categories;
        this.title = title;
        this.imageURL = imageURL;
        this.imageWidth = "";
        this.imageHeight = "";
        this.link = link;
        this.body = new StringBuffer(body);
    }

    Article(File file) {
        this.file = file;
        try {
            BufferedReader dis = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            String first = dis.readLine();
            if (first.equals("version 2")) {
                this.date = dis.readLine();
                this.categories = dis.readLine();
            } else {
                this.date = first;
                this.categories = "all";
            }
            this.title = dis.readLine();
            this.imageURL = dis.readLine();
            this.imageWidth = dis.readLine();
            this.imageHeight = dis.readLine();
            this.link = dis.readLine();
            String line = null;
            while ((line = dis.readLine()) != null) {
                this.body.append(String.valueOf(line) + "\n");
            }
            dis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.body = new StringBuffer(e.toString());
        }
    }

    public String getBody(Settings s) {
        StringBuffer rbody = new StringBuffer();
        if (this.imageURL != null && this.imageURL.trim().length() != 0) {
            if (this.link != null && this.link.trim().length() != 0) {
                rbody.append("<a href='" + this.link + "'>");
            }
            rbody.append("<img src='" + this.imageURL + "' width='" + this.imageWidth + "' height='" + this.imageHeight + "' align='left'>");
            if (this.link != null && this.link.trim().length() != 0) {
                rbody.append("</a>");
            }
        }
        rbody.append("<p>" + this.body + "</p>");
        return rbody.toString();
    }

    public String toHtml(Settings s) {
        Page page = new Page(s.template, "all");
        return page.substitute(s, this, false, true);
    }

    private String toHtml2(String base) {
        StringBuffer sb = new StringBuffer();
        sb.append("<table width='99%' border='0' cellspacing='0' cellpadding='0'>");
        sb.append("              <tr bgcolor='#CCCCCC'> ");
        sb.append("                <td align='left' valign='top' bgcolor='#003366'>" + base + "<font color='#FFFFFF'>");
        sb.append("<SPAN CLASS='title'>" + this.title + "</SPAN></font></td>");
        sb.append("                <td align='right' bgcolor='#003366'><SPAN CLASS='date'><font color='#CCCCCC'>" + this.date + "</font></SPAN></td>");
        sb.append("              </tr>");
        sb.append("              <tr> ");
        sb.append("                <td colspan='2' valign='top'>");
        if (this.imageURL != null && this.imageURL.trim().length() != 0) {
            sb.append("<a href='" + this.link + "'><img src='" + base + "/" + this.imageURL + "' width='" + this.imageWidth + "' height='" + this.imageHeight + "' align='left'></a>");
        }
        sb.append("<p>" + this.body + "</p>");
        sb.append("                 </td>");
        sb.append("              </tr>");
        sb.append("            </table>");
        return sb.toString();
    }

    private void toOtherHtml(PrintWriter out) {
        out.println("<table width='100%'>");
        out.println("<tr align='left' valign='top'>");
        out.println(" <td bgcolor='#d0ffd0'>");
        out.println(" <font color='black'>" + this.date + "</font>");
        out.println(" </td>");
        out.println("</tr>");
        out.println("<tr>");
        out.println(" <td>");
        out.println("<a href='" + this.link + "'><img src='" + this.imageURL + "' width='" + this.imageWidth + "' height='" + this.imageHeight + "' align='left'></a>");
        out.println("<p>" + this.body + "</p>");
        out.println("</td>");
        out.println("</tr>");
        out.println("</table>");
    }

    public void delete(ServletContext sc) {
        this.file.delete();
        String fileName = this.imageURL;
        int d = fileName.indexOf(47);
        fileName = fileName.substring(d + 1);
        Settings s = new Settings(sc.getResourceAsStream("/WEB-INF/settings.prop"));
        new File(s.imgDir, fileName).delete();
        Blog.clearMemoryCache();
    }

    public String getCategories() {
        return this.categories;
    }

    public boolean isInCategory(String cat) {
        String[] x = this.categories.split(",");
        int i = 0;
        while (i < x.length) {
            if (cat.equals(x[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getId() {
        if (this.file == null) {
            return "none-yet";
        }
        return this.file.getName();
    }
}

