/*
 * Decompiled with CFR 0.152.
 */
package j;

import j.Article;
import j.Blog;
import j.NImage;
import j.Page;
import j.Settings;
import java.awt.Image;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import javax.imageio.ImageIO;
import javax.servlet.ServletContext;

/*
 * Exception performing whole class analysis ignored.
 */
public class Blog {
    private Settings s;
    Image awtImage;
    public static String ALL = "all";
    private static ArrayList al = null;

    public Blog(ServletContext sc) {
        this.s = new Settings(sc.getResourceAsStream("/WEB-INF/settings.prop"));
    }

    public Blog(InputStream is) {
        this.s = new Settings(is);
    }

    public void updateStory(File file, String date, String category, String title, NImage image, String link, String body) {
        String unique = file.getName().substring(1);
        unique = unique.substring(0, unique.length() - 4);
        this.writeStory(file, unique, date, category, title, image, link, body);
    }

    public void newStory(String date, String category, String title, NImage image, String link, String body) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd-HHmmss");
        String unique = sdf.format(new Date());
        File newArticle = new File(this.s.artDir, "A" + unique + ".art");
        this.writeStory(newArticle, unique, date, category, title, image, link, body);
    }

    private void writeStory(File file, String unique, String date, String category, String title, NImage image, String link, String body) {
        if (this.awtImage != null) {
            this.awtImage.flush();
            this.awtImage = null;
        }
        this.s.dataDir.mkdirs();
        this.s.artDir.mkdirs();
        this.s.imgDir.mkdirs();
        this.s.templatesDir.mkdirs();
        File imageFile = null;
        if (image.imgLocalFile != null && image.imgLocalFile.exists()) {
            File uniqPubFile = this.genUniqPubFile(this.s, unique, image.imgLocalFile);
            this.copyFile(image.imgLocalFile, uniqPubFile);
            imageFile = uniqPubFile;
            this.s.getClass();
            image.imageURL = String.valueOf("aimg") + "/" + uniqPubFile.getName();
            File originalFile = NImage.genOrig((File)image.imgLocalFile);
            if (originalFile.exists()) {
                uniqPubFile = this.genUniqPubFile(this.s, unique, originalFile);
                this.copyFile(originalFile, uniqPubFile);
                this.s.getClass();
                String imageOrigURL = String.valueOf("aimg") + "/" + uniqPubFile.getName();
                if (link.equals(image.imageOrigURL)) {
                    link = imageOrigURL;
                }
            }
        }
        File newArticle = new File(this.s.artDir, "A" + unique + ".art");
        String cleanCatgories = Blog.scrubCategories((String)category);
        try {
            PrintWriter out = new PrintWriter(new FileWriter(newArticle));
            out.println("version 2");
            out.println(date);
            out.println(cleanCatgories);
            out.println(title);
            out.println(image.getImageURL());
            out.println(this.getWidth(imageFile));
            out.println(this.getHeight(imageFile));
            out.println(link);
            out.println(body);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Blog.clearMemoryCache();
        this.genBlog();
    }

    private File genUniqPubFile(Settings s, String unique, File imgLocalFile) {
        String name = imgLocalFile.getName();
        while (name.matches("I\\d{8}-\\d{6}-.*")) {
            name = name.substring(17);
        }
        String imgName = "I" + unique + "-" + name;
        return new File(s.imgDir, imgName);
    }

    public static String scrubCategories(String category) {
        ArrayList<String> al = new ArrayList<String>();
        String[] x = ("all," + category).split(",");
        int i = 0;
        while (i < x.length) {
            String cat = x[i].trim();
            if (!al.contains(cat)) {
                al.add(cat);
            }
            ++i;
        }
        Collections.sort(al);
        StringBuffer clean = new StringBuffer();
        int i2 = 0;
        while (i2 < al.size()) {
            if (i2 != 0) {
                clean.append(",");
            }
            clean.append(al.get(i2));
            ++i2;
        }
        return clean.toString();
    }

    public String genSample(Article story) {
        StringBuffer sb = new StringBuffer();
        Page page = new Page(this.s.template, ALL);
        sb.append(page.header);
        Article sample = new Article("Thursday, 07 September 2006", story.categories, "Sample Second article ", "", "http://slashdot.org", "a sample article to fill out look of preview");
        boolean imagePublishedAlready = new File(this.s.pubDir, story.imageURL).exists();
        sb.append(page.substitute(this.s, story, false, imagePublishedAlready));
        sb.append(page.substitute(this.s, sample, false, false));
        sb.append(page.footer);
        return sb.toString();
    }

    public void genBlog() {
        String[] cats = this.getCategories();
        int i = 0;
        while (i < cats.length) {
            String cat = cats[i];
            ArrayList articles = this.getArticles(cat);
            int max = articles.size();
            if (max > this.s.articlesOnMainPage) {
                max = this.s.articlesOnMainPage;
            }
            Article[] newArticles = this.getArticles(articles, 0, max);
            Article[] oldArticles = this.getArticles(articles, max, articles.size());
            String pageName = cat;
            if (cat.equals(ALL)) {
                pageName = "index";
            }
            this.genBlog(new File(this.s.pubDir, String.valueOf(pageName) + ".html"), this.s.template, newArticles, cat);
            this.genBlog(new File(this.s.pubDir, "older" + pageName + ".html"), this.s.oldTemplate, oldArticles, cat);
            this.genRSS(new File(this.s.pubDir, String.valueOf(cat) + ".rss"), new File(this.s.templatesDir, "feed.rss"), newArticles, cat);
            ++i;
        }
    }

    private Article[] getArticles(ArrayList articles, int start, int endExclusive) {
        Article[] arry = new Article[endExclusive - start];
        int j = 0;
        int i = start;
        while (i < endExclusive) {
            arry[j++] = (Article)articles.get(i);
            ++i;
        }
        return arry;
    }

    public ArrayList getArticles(String cat) {
        int i;
        if (al == null) {
            al = new ArrayList();
            File[] files = this.s.artDir.listFiles();
            if (files == null) {
                return al;
            }
            i = 0;
            while (i < files.length) {
                al.add(new Article(files[i]));
                ++i;
            }
            Collections.sort(al, new reverse(this));
        }
        if (cat.equals(ALL)) {
            return al;
        }
        ArrayList subset = new ArrayList();
        i = 0;
        while (i < al.size()) {
            Article a = (Article)al.get(i);
            if (a.isInCategory(cat)) {
                subset.add(al.get(i));
            }
            ++i;
        }
        return subset;
    }

    void genBlog(File outFile, File templatePage, Article[] arts, String cat) {
        try {
            PrintWriter out = new PrintWriter(new FileWriter(outFile));
            Page page = new Page(templatePage, cat);
            out.println(page.header);
            if (arts.length == 0) {
                out.println("<p>No news is good news.</p>");
            }
            int i = 0;
            while (i < arts.length) {
                out.println(page.substitute(this.s, arts[i], false, false));
                ++i;
            }
            out.println(page.footer);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void genRSS(File outFile, File templatePage, Article[] arts, String cat) {
        try {
            PrintWriter out = new PrintWriter(new FileWriter(outFile));
            Page page = new Page(templatePage, cat);
            out.println(page.header);
            int i = 0;
            while (i < arts.length) {
                out.println(page.substitute(this.s, arts[i], true, true));
                ++i;
            }
            out.println(page.footer);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    int getWidth(File imgFile) {
        if (imgFile == null || !imgFile.exists()) {
            return -1;
        }
        if (this.awtImage == null) {
            this.load(imgFile);
        }
        return this.awtImage.getWidth(null);
    }

    int getHeight(File imgFile) {
        if (imgFile == null || !imgFile.exists()) {
            return -1;
        }
        if (this.awtImage == null) {
            this.load(imgFile);
        }
        return this.awtImage.getHeight(null);
    }

    private void load(File imgFile) {
        System.out.println("Trying to load this image: " + imgFile.toString());
        try {
            this.awtImage = ImageIO.read(imgFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void copyFile(File in, File out) {
        try {
            FileInputStream fis = new FileInputStream(in);
            FileOutputStream fos = new FileOutputStream(out);
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = fis.read(buf)) != -1) {
                fos.write(buf, 0, i);
            }
            fis.close();
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String[] getCategories() {
        ArrayList al = this.getArticles(ALL);
        ArrayList<String> categories = new ArrayList<String>();
        int i = 0;
        while (i < al.size()) {
            String[] c = ((Article)al.get(i)).getCategories().split(",");
            int ac = 0;
            while (ac < c.length) {
                if (!categories.contains(c[ac].trim())) {
                    categories.add(c[ac].trim());
                }
                ++ac;
            }
            ++i;
        }
        if (categories.size() == 0) {
            return new String[]{"all"};
        }
        return categories.toArray(new String[categories.size()]);
    }

    public static void clearMemoryCache() {
        al = null;
    }
}

