/*
 * Decompiled with CFR 0.152.
 */
package j;

import j.Article;
import j.Blog;
import j.Settings;
import java.io.File;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class Page {
    static final String foreach = "{$ foreach $}";
    static final String next = "{$ next $}";
    String header = "<p>Header";
    String footer = "<p>Header";
    private String template;
    String category;
    public static SimpleDateFormat RFC822DATEFORMAT = new SimpleDateFormat("EEE', 'dd' 'MMM' 'yyyy' 'HH:mm:ss' 'Z", Locale.US);
    SimpleDateFormat artDateFormat = new SimpleDateFormat("EEEE, dd MMMM yyyy");

    Page(File tfile, String category) {
        this.category = category;
        try {
            FileInputStream fis = new FileInputStream(tfile);
            byte[] b = new byte[fis.available()];
            fis.read(b);
            String x = new String(b);
            int foreachLoc = x.indexOf(foreach);
            if (foreachLoc == -1) {
                this.error("{$ foreach $} tag not found");
                return;
            }
            int nextLoc = x.indexOf(next);
            if (nextLoc == -1) {
                this.error("{$ next $} tag not found");
                return;
            }
            this.header = x.substring(0, foreachLoc);
            String feedname = String.valueOf(category) + ".rss";
            this.header = this.replaceAll(this.header, "{$ feedname $}", feedname);
            this.header = this.replaceAll(this.header, "{$ category $}", category);
            this.template = x.substring(foreachLoc + foreach.length(), nextLoc);
            this.footer = x.substring(nextLoc + next.length());
            this.footer = this.replaceAll(this.footer, "{$ category $}", category);
            String older = "older" + category + ".html";
            if (category.equals(Blog.ALL)) {
                older = "olderindex.html";
            }
            this.footer = this.replaceAll(this.footer, "{$ olderPage $}", older);
        }
        catch (Exception e) {
            this.error("Exception: " + e);
            e.printStackTrace();
        }
    }

    void error(String errmsg) {
        this.header = "<h2>" + errmsg + "</h2>";
        this.template = " ";
        this.footer = " ";
    }

    String substitute(Settings s, Article art, boolean rss, boolean imagePublishedAlready) {
        String body = art.getBody(s);
        if (imagePublishedAlready) {
            body = body.replaceAll("<img src='aimg/", "<img src='" + s.pubURL + "aimg/");
        }
        if (rss) {
            body = body.replaceAll("&", "&amp;");
            body = body.replaceAll("<", "&lt;");
            body = body.replaceAll(">", "&gt;");
        }
        String nvalue = "";
        nvalue = this.replaceAll(this.template, "{$ body $}", this.hackBody(body, art.link));
        nvalue = this.replaceAll(nvalue, "{$ headline $}", art.title);
        nvalue = this.replaceAll(nvalue, "{$ title $}", art.title);
        nvalue = this.replaceAll(nvalue, "{$ date $}", art.date);
        nvalue = this.replaceAll(nvalue, "{$ rssdate $}", this.rfc822Date(art.date));
        nvalue = this.replaceAll(nvalue, "{$ id $}", art.getId());
        nvalue = this.replaceAll(nvalue, "{$ categories $}", this.createCategoriesString(art, this.category));
        return nvalue;
    }

    private String hackBody(String body, String link) {
        return body.replaceAll("\\[\\[(.*)\\]\\]", "<a href='" + link + "'>$1</a>");
    }

    private String rfc822Date(String date) {
        try {
            Date rdate = this.artDateFormat.parse(date);
            return RFC822DATEFORMAT.format(rdate);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "date issue";
        }
    }

    private String createCategoriesString(Article art, String activeCategory) {
        String[] c = art.getCategories().split(",");
        StringBuffer sb = new StringBuffer();
        if (c.length == 1) {
            sb.append("Category: ");
        } else {
            sb.append("Categories: ");
        }
        int i = 0;
        while (i < c.length) {
            if (i != 0) {
                sb.append(", ");
            }
            if (c[i].equals(activeCategory)) {
                sb.append(c[i]);
            } else {
                String page = c[i];
                if (page.equals("all")) {
                    page = "index";
                }
                try {
                    sb.append("<a href='" + URLEncoder.encode(page, "UTF-8") + ".html'>");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                sb.append(c[i]);
                sb.append("<a>");
            }
            ++i;
        }
        return sb.toString();
    }

    String replaceAll(String src, String match, String replace) {
        int loc = -1;
        while ((loc = src.indexOf(match)) != -1) {
            src = String.valueOf(src.substring(0, loc)) + replace + src.substring(loc + match.length());
        }
        return src;
    }
}

