/*
 * Decompiled with CFR 0.152.
 */
package j;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Properties;
import javax.servlet.ServletContext;

public class Settings {
    Properties prop = new Properties();
    public String pubURL;
    public File pubDir;
    public File pubIndex;
    public File pubOldIndex;
    public int articlesOnMainPage;
    public File dataDir;
    public File imgDir;
    public File artDir;
    public File templatesDir;
    public File template;
    public File oldTemplate;
    final String imgSubDir = "aimg";
    public String shortName;

    public Settings(ServletContext sc) {
        this(sc.getResourceAsStream("/WEB-INF/settings.prop"));
    }

    public Settings(InputStream is) {
        try {
            this.prop.load(is);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.pubURL = this.get("publicURL");
        this.pubDir = this.getFile("publishToDir");
        this.dataDir = this.getFile("dataDir");
        this.articlesOnMainPage = this.getInt("articlesOnMainPage");
        this.deriveValues();
    }

    String get(String key) {
        if (this.prop.get(key) == null) {
            return "NOT SET";
        }
        return (String)this.prop.get(key);
    }

    int getInt(String key) {
        if (this.prop.get(key) == null) {
            return -1;
        }
        return Integer.parseInt(this.get(key));
    }

    File getFile(String key) {
        if (this.get(key) == null) {
            return new File("NOT SET");
        }
        return new File(this.get(key));
    }

    public void save() {
        this.pubURL = this.get("publicURL");
        this.pubDir = this.getFile("publishToDir");
        this.dataDir = this.getFile("dataDir");
        this.articlesOnMainPage = this.getInt("articlesOnMainPage");
        this.prop.put("publicURL", this.pubURL);
        this.prop.put("publishToDir", this.pubDir.toString());
        this.prop.put("dataURL", this.dataDir.toString());
        this.prop.put("articlesOnMainPage", "" + this.articlesOnMainPage);
        try {
            this.prop.store(new FileOutputStream("settings.prop"), "header");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void deriveValues() {
        this.pubIndex = new File(this.pubDir, "index.html");
        this.pubOldIndex = new File(this.pubDir, "olderstuff.html");
        this.imgDir = new File(this.pubDir, "aimg");
        this.artDir = new File(this.dataDir, "articles");
        this.templatesDir = new File(this.dataDir, "templates");
        this.template = new File(this.templatesDir, this.pubIndex.getName());
        this.oldTemplate = new File(this.templatesDir, this.pubOldIndex.getName());
        String almostPub = this.pubURL.toString().substring(0, this.pubURL.toString().length() - 1);
        this.shortName = almostPub.substring(almostPub.lastIndexOf(47) + 1);
    }
}

